/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	DislikeList
**
** DESCRIPTION:	A list of things a villager dislikes
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef DISLIKE_LIST_H
#define DISLIKE_LIST_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "LikeTypes.h"
#include "LikeList.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int DislikeList_c_iMaxDislikes = 3;
const int DislikeList_c_iMaxInitialDislikes = 2;
const int DislikeList_c_iChanceOfDislikingSomething = 25;	// (1-100)

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CDislikeList
{
private:

	//class data
	ELike		m_eDislike[DislikeList_c_iMaxDislikes];

	//class methods
	//setup
	public:		CDislikeList();
	public:		void Reset();
	public:		void Initialize(CLikeList &LikeList);

	//process
	public:		const bool Add(ELike eDislike);
	public:		const bool Remove(ELike eDislike);

	//access
	public:		const bool Contains(ELike eDislike) const;
	public:		const char *GetListAsString() const;
};

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/